<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('Edit Service'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="card card-primary card-form m-0 m-md-4 my-4 m-md-0 shadow">
        <div class="card-body ">
            
            <form action="<?php echo e(route('admin.service.update')); ?>" method="POST" class="form">
                <?php echo csrf_field(); ?>
                <h5 class="table-group-title text-info mb-2 mb-md-3"><span><?php echo app('translator')->get('Service Basic'); ?></span></h5>
                <input type="hidden" name="id" value="<?php echo e($service->id); ?>">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group ">
                            <label><?php echo app('translator')->get('Service Title'); ?></label>
                            <input type="text" name="service_title"
                                   value="<?php echo e(old('service_title',$service->service_title)); ?>"
                                   class="form-control form-control-sm">
                            <?php if($errors->has('service_title')): ?>
                                <div class="error text-danger"><?php echo app('translator')->get($errors->first('service_title')); ?> </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Select Category'); ?></label>
                            <select class="form-control" id="category_id" name="category_id">
                                <option value="<?php echo e(old('category_id',$service->category_id)); ?>" selected
                                        hidden><?php echo app('translator')->get('Change Category'); ?></option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>"
                                            <?php if($service->category_id == $category->id ): ?> selected <?php endif; ?>><?php echo e($category->category_title); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                        </div>
                        <?php if($errors->has('category_id')): ?>
                            <div class="error text-danger mt-2"><?php echo app('translator')->get($errors->first('category_id')); ?> </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="divider"></div>
                <h5 class="table-group-title text-primary mb-2 mb-md-3"><span><?php echo app('translator')->get('Price & Status'); ?></span></h5>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Minimum Amount'); ?></label>
                            <input type="number" class="form-control square" name="min_amount"
                                   value="<?php echo e(old('min_amount',$service->min_amount)); ?>">
                            <?php if($errors->has('min_amount')): ?>
                                <div class="error text-danger"><?php echo app('translator')->get($errors->first('min_amount')); ?> </div>
                            <?php endif; ?>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Rate per 1000'); ?> </label>
                            <input type="text" class="form-control square" name="price" placeholder="50.25"
                                   value="<?php echo e(old('price',$service->price)); ?>">
                            <?php if($errors->has('price')): ?>
                                <div class="error text-danger"><?php echo app('translator')->get($errors->first('price')); ?> </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Maximum Amount'); ?></label>
                            <input type="number" class="form-control square" name="max_amount"
                                   value="<?php echo e(old('max_amount',$service->max_amount)); ?>">
                            <?php if($errors->has('max_amount')): ?>
                                <div class="error text-danger"><?php echo app('translator')->get($errors->first('max_amount')); ?> </div>
                            <?php endif; ?>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group ">
                                    <label class="d-block"><?php echo app('translator')->get('Status'); ?> </label>
                                    <div class="custom-switch-btn">
                                        <input type='hidden' value='1' name='service_status'>
                                        <input type="checkbox" name="service_status" class="custom-switch-checkbox"
                                               id="service_status"
                                               value="0" <?php echo e($service->service_status == '0' ? 'checked': ''); ?> >
                                        <label class="custom-switch-checkbox-label" for="service_status">
                                            <span class="custom-switch-checkbox-inner"></span>
                                            <span class="custom-switch-checkbox-switch"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group ">
                                    <label class="d-block"><?php echo app('translator')->get('Drip feed'); ?></label>
                                    <div class="custom-switch-btn">
                                        <input type='hidden' value='1' name='drip_feed'>
                                        <input type="checkbox" name="drip_feed" class="custom-switch-checkbox"
                                               id="drip_feed"
                                               value="0" <?php echo e($service->drip_feed == '0' ? 'checked': ''); ?> >
                                        <label class="custom-switch-checkbox-label" for="drip_feed">
                                            <span class="custom-switch-checkbox-inner"></span>
                                            <span class="custom-switch-checkbox-switch"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="divider"></div>
                <h5 class="table-group-title text-primary mb-2 mb-md-3"><span><?php echo app('translator')->get('Type & Details'); ?> </span></h5>
                <div class="form-group ">
                    <div class="switch-field d-flex">
                        <div class="form-check p-0">
                            <input class="form-check-input" type="radio" name="manual_api" id="less"
                                   value="0" <?php echo e(old('manual_api') == 0 || !isset($service->api_provider_id) || !isset($service->api_service_id) ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="less">
                                <?php echo app('translator')->get('Manual'); ?>
                            </label>
                        </div>
                        <div class="form-check p-0">
                            <input class="form-check-input" type="radio" name="manual_api" id="more"
                                   value="1" <?php echo e(old('manual_api') == 1 || isset($service->api_provider_id, $service->api_service_id) ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="more">
                                <?php echo app('translator')->get('Api'); ?>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row moreField <?php echo e(old('manual_api') == 1 || isset($service->api_provider_id, $service->api_service_id) ? '' : 'd-none'); ?>">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label " for="apiprovider"><?php echo app('translator')->get('API Provider Name'); ?></label>
                            <select class="form-control" name="api_provider_id">
                                <option value="0"><?php echo app('translator')->get('Select API Provider name'); ?></option>
                                <?php $__currentLoopData = $apiProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apiProvider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($apiProvider->id); ?>" <?php echo e(old('api_provider_id', $service->api_provider_id) == $apiProvider->id ? 'selected' : ''); ?>><?php echo e($apiProvider->api_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('api_provider_id')): ?>
                                <div class="error text-danger"><?php echo app('translator')->get($errors->first('api_provider_id')); ?> </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('API Service ID'); ?></label>
                            <input type="text" class="form-control square" name="api_service_id"
                                   value="<?php echo e(old('api_service_id', $service->api_service_id)); ?>"
                                   placeholder="<?php echo app('translator')->get('Api Service ID'); ?>">
                            <?php if($errors->has('api_service_id')): ?>
                                <div class="error text-danger"><?php echo app('translator')->get($errors->first('api_service_id')); ?> </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label><?php echo app('translator')->get('Select Refill'); ?></label>
                    <select class="form-control" name="refill" id="refill">
                        <option disabled value="" hidden><?php echo app('translator')->get('Select Refill'); ?></option>
                        <option value="1" <?php echo e(($service->refill == 1) && ($service->is_automatic == 0)  ? 'selected' : ''); ?>><?php echo app('translator')->get('Manual'); ?></option>
                        <option value="2" <?php echo e(($service->refill == 1) && ($service->is_automatic == 1)  ? 'selected' : ''); ?> class="automatic"><?php echo app('translator')->get('Automatic'); ?></option>
                        <option value="3" <?php echo e(($service->refill == 0) && ($service->is_automatic == 0)  ? 'selected' : ''); ?>><?php echo app('translator')->get('Off'); ?></option>
                    </select>
                    <?php if($errors->has('refill')): ?>
                        <div class="error text-danger"><?php echo app('translator')->get($errors->first('refill')); ?> </div>
                    <?php endif; ?>
                </div>

                <div class="form-group mt-4">
                    <label class="control-label " for="description"><?php echo app('translator')->get('Description'); ?></label>
                    <textarea class="form-control" rows="8"
                              name="description"><?php echo e(old('description', $service->description)); ?></textarea>

                </div>
                <button type="submit" class="btn btn-primary btn-block mt-3"><span><i
                                class="fas fa-save pr-2"></i> <?php echo app('translator')->get('Save Changes'); ?></span>
                </button>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict";

        var $serviceType = '';

        $serviceType = $('input[name=manual_api]:checked').val();

        checkType($serviceType);

        $(document).on('click', '#more', function () {
            $(".moreField").removeClass('d-none');

        });
        $(document).on('click', '#less', function () {
            $(".moreField").addClass('d-none');
        });

        $(document).on('click',"input[name=manual_api]:checked", function () {
        $serviceType = $(this).val();
        checkType($serviceType);
        });

        function checkType(serviceType){
            if(serviceType == 0){
                // $('select[name=refill]').val('')
                $(".automatic").addClass('d-none');
                return 0;
            }else{
                // $('select[name=refill]').val('')
                $(".automatic").removeClass('d-none');
                return 0;
            }

        }

        $(document).ready(function () {
            $('#category_id').select2({
                selectOnClose: true
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\SMM_200823\project\resources\views/admin/pages/services/edit-service.blade.php ENDPATH**/ ?>