<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('Service Show'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-header card card-primary m-0 m-md-4 my-4 m-md-0 p-5 shadow">
        <div class="row ">
            <div class="col-xl-12">
                <form action="<?php echo e(route('admin.service-search')); ?>" method="get">
                    <div class="row">
                        <div class="col-md-4 col-xl-3">
                            <div class="form-group">
                                <input type="text" name="service" value="<?php echo e(@request()->service); ?>" class="form-control"
                                       placeholder="<?php echo app('translator')->get('Type Here'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4 col-xl-3">
                            <div class="form-group">
                                <select name="category" id="category" class="form-control statusfield">
                                    <option value="-1"
                                            <?php if(@request()->category == '-1'): ?> selected <?php endif; ?>><?php echo app('translator')->get('All Category'); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"
                                                <?php if(@request()->category == $category->id): ?> selected <?php endif; ?>><?php echo app('translator')->get($category->category_title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4 col-xl-2">
                            <div class="form-group">
                                <select name="provider" id="provider" class="form-control statusfield">
                                    <option value="-1"
                                            <?php if(@request()->provider == '-1'): ?> selected <?php endif; ?>><?php echo app('translator')->get('All Provider'); ?></option>
                                    <?php $__currentLoopData = $apiProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($provider->id); ?>"
                                                <?php if(@request()->provider == $provider->id): ?> selected <?php endif; ?>><?php echo app('translator')->get($provider->api_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4 col-xl-2">
                            <div class="form-group">
                                <select name="status" class="form-control">
                                    <option value="-1"
                                            <?php if(@request()->status == '-1'): ?> selected <?php endif; ?>><?php echo app('translator')->get('All Status'); ?></option>
                                    <option value="1"
                                            <?php if(@request()->status == '1'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Active'); ?></option>
                                    <option value="0"
                                            <?php if(@request()->status == '0'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Inactive'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4 col-xl-2">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary w-100 w-sm-auto"><i
                                        class="fas fa-search"></i> <?php echo app('translator')->get('Search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="d-flex justify-content-start justify-content-xl-end">

                                <button type="button" class="btn btn-sm btn-primary  mr-3" data-toggle="modal"
                                        data-target="#importServiceModal">
                                    <span> <?php echo app('translator')->get('Import Services'); ?></span>
                                </button>

                                <div class="dropdown">
                                    <button class="btn btn-dark  btn-sm dropdown-toggle" type="button"
                                            id="dropdownMenuButton"
                                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <span><i class="fas fa-bars pr-2"></i> <?php echo app('translator')->get('Action'); ?></span>
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <button class="dropdown-item" type="button" data-toggle="modal"
                                                data-target="#all_active"><?php echo app('translator')->get('Active'); ?></button>
                                        <button class="dropdown-item" type="button" data-toggle="modal"
                                                data-target="#all_deactive"><?php echo app('translator')->get('Inactive'); ?></button>
                                        <button class="dropdown-item" type="button" data-toggle="modal"
                                                data-target="#delete"><?php echo app('translator')->get('Delete'); ?></button>
                                        <button class="dropdown-item" type="button" data-toggle="modal"
                                                data-target="#priceModal"><?php echo app('translator')->get('Price Update'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="accordion" class="accordion-service">
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>  $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card card-primary m-0 m-md-4 my-1 m-md-0 ">
                <div class="card-header" id="faqhead<?php echo e($category->id); ?>">
                    <a href="#" class="btn btn-header-link" data-toggle="collapse"
                       data-target="#faq<?php echo e($category->id); ?>" aria-expanded="true"
                       aria-controls="faq<?php echo e($category->id); ?>">
                        <?php echo e($category->category_title); ?>

                    </a>
                </div>

                <div id="faq<?php echo e($category->id); ?>" class="collapse <?php if($loop->first): ?> show <?php endif; ?>"
                     aria-labelledby="faqhead<?php echo e($category->id); ?>" data-parent="#accordion">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table
                                class="categories-show-table table table-hover  table-striped table-bordered  text-right text-lg-center">
                                <thead class="thead-primary">
                                <tr>
                                    <th scope="col">
                                        <input type="checkbox"
                                               class="form-check-input check-all tic-check check-all-tic"
                                               id="cat-tic-<?php echo e($key); ?>"
                                               name="check-all">
                                        <label for="cat-tic-<?php echo e($key); ?>"></label>
                                    </th>

                                    <th scope="col"><?php echo app('translator')->get('ID'); ?></th>
                                    <th scope="col" class="text-left"><?php echo app('translator')->get('Name'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Provider'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Drip-Feed'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $category->service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td class="text-center check-box-width-50">
                                            <input type="checkbox"
                                                   class="form-check-input row-tic tic-check row-tic-check"
                                                   id="service-tic-<?php echo e($service->id); ?>"
                                                   name="check" value="<?php echo e($service->id); ?>" data-id="<?php echo e($service->id); ?>">
                                            <label for="service-tic-<?php echo e($service->id); ?>"></label>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('ID'); ?>"><?php echo app('translator')->get($service->id); ?></td>

                                        <td data-label="<?php echo app('translator')->get('Name'); ?>" class="text-right text-lg-left">
                                            <a href="javascript:void(0)" data-container="body" data-toggle="popover"
                                               data-placement="top" data-content="<?php echo e($service->service_title); ?>">
                                                <?php echo e(\Str::limit($service->service_title, 30)); ?>

                                            </a>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Provider'); ?>">
                                            <?php echo e(optional($service->provider)->api_name ?? 'N/A'); ?>

                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Drip-Feed'); ?>">
                                    <span
                                        class="badge badge-pill <?php echo e($service->drip_feed == 0 ? 'badge-danger' : 'badge-success'); ?>"><?php echo e($service->drip_feed == 0 ? 'Inactive' : 'Active'); ?></span>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    <span
                                        class="badge badge-pill <?php echo e($service->service_status == 0 ? 'badge-danger' : 'badge-success'); ?>"><?php echo e($service->service_status == 0 ? 'Inactive' : 'Active'); ?></span>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                            <a href="<?php echo e(route('admin.service.edit',['id'=>$service->id])); ?>"
                                               class="btn btn-primary btn-rounded btn-sm" title="<?php echo app('translator')->get('Edit'); ?>">
                                                <i class="fa fa-edit"
                                                   aria-hidden="true"></i>
                                            </a>

                                            <?php if($service->service_status == 0): ?>
                                                <a href="javascript:void(0)"
                                                   class="btn btn-success btn-rounded btn-sm status-change"
                                                   data-toggle="modal"
                                                   data-target="#statusMoldal"
                                                   data-route="<?php echo e(route('admin.service.status.change',['id'=>$service->id])); ?>">
                                                    <i class="fa fa-check-circle  "
                                                       aria-hidden="true"></i>
                                                </a>
                                            <?php else: ?>
                                                <a href="javascript:void(0)"
                                                   class="btn btn-danger btn-rounded btn-sm status-change"
                                                   data-toggle="modal"
                                                   data-target="#statusMoldal"
                                                   data-route="<?php echo e(route('admin.service.status.change',['id'=>$service->id])); ?>">
                                                    <i class="fa fa-times-circle  "
                                                       aria-hidden="true"></i>
                                                </a>

                                            <?php endif; ?>

                                            <button type="button" class="btn btn-secondary btn-rounded btn-sm"
                                                    data-toggle="modal"
                                                    data-target="#description" id="details"
                                                    data-toggle="tooltip" title="<?php echo app('translator')->get('Details'); ?>"
                                                    data-servicetitle="<?php echo e($service->service_title); ?>"
                                                    data-description="<?php echo e($service->description); ?>"
                                                    data-rateper="<?php echo e($service->price); ?>"
                                                    data-orderlimit="<?php echo e($service->min_amount .' - ' .$service->max_amount); ?>">
                                                <i class="fa fa-info-circle"></i>
                                            </button>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <?php if($categories->total() > config('basic.paginate')): ?>
        <div class="card card-primary m-0 m-md-4 my-4 m-md-0">
            <div class="card-body">
                <?php echo e($categories->links()); ?>

            </div>
        </div>
    <?php endif; ?>

    <div class="modal fade" id="statusMoldal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog " role="document">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirm Status Change'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="" method="post" id="statusForm">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <h2><i class="fas fa-sync-alt position-absolute"></i></h2>
                        <div class="body-centent pl-5">
                            <p><?php echo app('translator')->get('Are you want to change the current status'); ?></p>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-dismiss="modal"><span><?php echo app('translator')->get('No'); ?></span>
                        </button>
                        <button type="submit" class="btn btn-primary"><span><?php echo app('translator')->get('Yes'); ?></span></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="importServiceModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog " role="document">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirm Import Services'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.api.services')); ?>" method="post" id="getServicesForm">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="body-centent">
                            <div class="dropdown">
                                <select class="form-control" name="api_provider_id">
                                    <option selected="" disabled><?php echo app('translator')->get('Select API Provider'); ?></option>
                                    <?php $__currentLoopData = $apiProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apiProvider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($apiProvider->id); ?>"><?php echo e($apiProvider->api_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">

                        <button type="button" class="btn btn-light" data-dismiss="modal">
                            <span><i class="fas fa-power-off"></i> <?php echo app('translator')->get('Cancel'); ?></span>
                        </button>

                        <button type="submit" class="btn btn-primary">
                            <span><i class="fas fa-search"></i> <?php echo app('translator')->get('Get Services'); ?></span>
                        </button>

                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="description">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="title"></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <p id="servicedescription"></p>
                    <p><strong><?php echo e(trans('Rate Per 1k')); ?> :</strong> <span
                            id="rateper"></span> <?php echo e(config('basic.currency')); ?> </p>
                    <p><strong><?php echo e(trans('Order Limit')); ?> :</strong> <span id="orderlimit"></span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="all_active" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="title"><?php echo app('translator')->get('Active Confirmation'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <div class="modal-body">
                    <h2><i class="fas fa-sync-alt position-absolute"></i></h2>
                    <div class="body-centent pl-5">
                        <p><?php echo app('translator')->get('Are you really want to active the category'); ?></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal"><?php echo app('translator')->get('No'); ?>
                    </button>
                    <form action="" method="post">
                        <?php echo csrf_field(); ?>
                        <a href="" class="btn btn-primary active-yes"><span><?php echo app('translator')->get('Yes'); ?></span></a>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="all_deactive" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="title"><?php echo app('translator')->get('Inactive Confirmation'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <div class="modal-body">
                    <h2><i class="fas fa-sync-alt position-absolute"></i></h2>
                    <div class="body-centent pl-5">
                        <p><?php echo app('translator')->get('Are you really want to Inactive the category'); ?></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal"><span><?php echo app('translator')->get('No'); ?></span></button>
                    <form action="" method="post">
                        <?php echo csrf_field(); ?>
                        <a href="" class="btn btn-primary deactive-yes"><span><?php echo app('translator')->get('Yes'); ?></span></a>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="delete" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="title"><?php echo app('translator')->get('Delete Confirmation'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <div class="modal-body">
                    <h2><i class="fas fa-trash position-absolute"></i></h2>
                    <div class="body-centent pl-5">
                        <p><?php echo app('translator')->get('Are you really want to delete the service?'); ?></p>
                    </div>

                    <small
                        class="text-danger p-0 m-0"><?php echo app('translator')->get('*Note : Service which have order can\'t be deleted.'); ?></small>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal"><?php echo app('translator')->get('No'); ?>
                    </button>
                    <form action="" method="post">
                        <?php echo csrf_field(); ?>
                        <a href="" class="btn btn-primary delete-yes"><span><?php echo app('translator')->get('Yes'); ?></span></a>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="priceModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog " role="document">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title"><?php echo app('translator')->get('Update Price'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <p><?php echo app('translator')->get('Are you really want to chnage the price of All Services?'); ?></p>
                        <label><?php echo app('translator')->get('Select Percentage Increase'); ?></label>
                        <select class="form-control price_percentage_increase" name="price_percentage_increase">
                            <option value="100" selected><?php echo app('translator')->get('100%'); ?></option>
                            <?php for($loop = 0; $loop <= 1000; $loop++): ?>
                                <option value="<?php echo e($loop); ?>"><?php echo e($loop); ?> %</option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal"><span><i
                                class="fas fa-power-off"></i> <?php echo app('translator')->get('Cancel'); ?></span></button>
                    <button type="button" class="btn btn-primary price-update"><span><i
                                class="fas fa-save"></i> <?php echo app('translator')->get('Save Changes'); ?></span></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function () {
            "use strict";
            $(document).on('click', '.check-all-tic', function () {
                $(this).closest('table').find('input:checkbox').prop('checked', this.checked);
            });

            $(document).on('click', '.row-tic-check', function () {
                if ($(this).closest('table').find('.row-tic-check').length == $(this).closest('table').find('.row-tic-check:checked').length) {
                    $(this).closest('table').find('.check-all-tic').prop('checked', this.checked);
                } else {
                    $(this).closest('table').find('.check-all-tic').prop('checked', false);
                }
            });

            $(document).on('click', '.status-change', function () {
                let route = $(this).data('route');
                $('#statusForm').attr('action', route);
            });

            //modal show
            $(document).on('click', '#details', function () {
                var title = $(this).data('servicetitle');
                var description = $(this).data('description');
                var rateper = $(this).data('rateper');
                var orderlimit = $(this).data('orderlimit');
                $('#title').text(title);
                $('#servicedescription').text(description);
                $('#rateper').text(rateper);
                $('#orderlimit').text(orderlimit);
            });

            //dropdown menu is not working
            $(document).on('click', '.dropdown-menu', function (e) {
                e.stopPropagation();
            });

            //multiple active
            $(document).on('click', '.active-yes', function (e) {
                e.preventDefault();
                var allVals = [];
                $(".row-tic:checked").each(function () {
                    allVals.push($(this).attr('data-id'));
                });
                var strIds = allVals.join(",");
                $.ajax({
                    headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                    url: "<?php echo e(route('admin.service-multiple-active')); ?>",
                    data: {strIds: strIds},
                    datatType: 'json',
                    type: "get",
                    success: function (data) {
                        location.reload();
                    }
                });
            });

            //multiple deactive
            $(document).on('click', '.deactive-yes', function (e) {
                e.preventDefault();
                var allVals = [];
                $(".row-tic:checked").each(function () {
                    allVals.push($(this).attr('data-id'));
                });
                var strIds = allVals.join(",");
                $.ajax({
                    headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                    url: "<?php echo e(route('admin.service-multiple-deactive')); ?>",
                    data: {strIds: strIds},
                    datatType: 'json',
                    type: "get",
                    success: function (data) {
                        location.reload();
                    }
                });
            });

            //multiple delete
            $(document).on('click', '.delete-yes', function (e) {
                e.preventDefault();
                var allVals = [];
                $(".row-tic:checked").each(function () {
                    allVals.push($(this).attr('data-id'));
                });
                var strIds = allVals.join(",");
                $.ajax({
                    headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                    url: "<?php echo e(route('admin.service-multiple-delete')); ?>",
                    data: {strIds: strIds},
                    datatType: 'json',
                    type: "get",
                    success: function (data) {
                        location.reload();
                    }
                });
            });

            //multiple price update
            $(document).on('click', '.price-update', function (e) {
                e.preventDefault();
                var allVals = [];
                var percentage = $('.price_percentage_increase').val();
                $(".row-tic:checked").each(function () {
                    allVals.push($(this).attr('data-id'));
                });
                var strIds = allVals.join(",");
                $.ajax({
                    headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                    url: "<?php echo e(route('admin.service-multiple-price-update')); ?>",
                    data: {strIds: strIds, percentage: percentage},
                    datatType: 'json',
                    type: "get",
                    success: function (data) {
                        location.reload();
                    }
                });
            });

            $('#category').select2({
                selectOnClose: true
            });

            $('#provider').select2({
                selectOnClose: true
            });

            $('select[name=status]').select2({
                selectOnClose: true
            });

        });
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\SMM_200823\project\resources\views/admin/pages/services/show-service.blade.php ENDPATH**/ ?>